%Input data: 
data='concentrations.dat'; %Name of the file with times between concentration measurements, number of impacted photons and concentrations of both substances (A, B): 
%First column: time [s],  
%second column: molar number of photons that impacted on the actinometer in the neighbouring cuvette [mol],  
%third column: molar concentration of the substance A [mol/l],  
%fourth column: molar concentration of the substance B [mol/l]. 
%The first number in both the first and the second column should be zero. 

split_ratio=1; %ratio between photon fluxes on the cuvette with explored substances (A <-> B) and on the cuvette with the actinometer 

mol_abs_koef='epsilon.dat'; %molar absorption coefficients:
%first column: wavelength,  
%second column: molar absorption coefficient of the substance A [l/mol.cm],  
%third column: molar absorption coefficient of the substance B [l/mol.cm]. 

KAb=7.24e-7; %Rate constant of the thermal reaction A -> B [s-1] 

KBa=0; %Rate constant of the thermal reaction B -> A [s-1] 

Lcm=1; %cuvette length [cm]

Vml=4.7; %sample volume [ml] 

spektrum='irradiation_beam.txt';  %The name of the file with the irradiation spectrum 

vlndel_r=[265 295];  %The wavelength range (two wavelength values), where the effective absorption coefficients will be calculated

vlndel_pozadi=[420 800];  %The wavelength range (two wavelength values), where the background of the irradiation spectrum will be determined. (When the background should not be substracted, input an empty vector "vlndel_pozadi=[];".) 





%Fit parameters: 

presnost=3.5; %A degree of precission in the numerical calculation. Higher value of this parameter means shorter calculation step, i.e. higher precission, but slower calculation. 

deltader=1e-3; %Magnitude of the step used by numerical calculation of derivates that are needed for calculation of confidence intervals. (Usually used value "deltader=1e-3;"). 

